/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker;

import LegendaryCardMaker.CardMakerToolbar;
import LegendaryCardMaker.LegendaryCardMakerFrame;
import LegendaryCardMaker.LegendarySchemeMaker.SchemeCardType;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import javax.swing.JColorChooser;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class SchemeTypeSelectorMenu
extends JMenu
implements ActionListener {
    JMenuItem newSchemeType = new JMenuItem("New Scheme Type...");
    JMenuItem rename = new JMenuItem("Rename Scheme Type...");
    JMenuItem headingColour = new JMenuItem("Change Heading Colour...");
    JMenuItem customHeadings = new JMenuItem("Change Custom Headings...");
    JMenuItem delete = new JMenuItem("Delete Scheme Type...");
    private Locale currentLocale = Locale.getDefault();
    private ResourceBundle labels = ResourceBundle.getBundle("LegendaryCardMaker.tools.language.LegendaryCardMakerMenu", this.currentLocale);
    public LegendaryCardMakerFrame lcmf;
    static CardMakerToolbar tb = null;

    public void setLanguage() {
        this.newSchemeType.setText(this.labels.getString("NewSchemeType"));
        this.rename.setText(this.labels.getString("RenameSchemeType"));
        this.headingColour.setText(this.labels.getString("ChangeHeadingColour"));
        this.customHeadings.setText(this.labels.getString("ChangeCustomHeadings"));
        this.delete.setText(this.labels.getString("DeleteSchemeType"));
    }

    public SchemeTypeSelectorMenu(LegendaryCardMakerFrame lcmf, CardMakerToolbar tb) {
        this.setLanguage();
        SchemeTypeSelectorMenu.tb = tb;
        this.lcmf = lcmf;
        this.setText("Edit");
        this.newSchemeType.addActionListener(this);
        this.add(this.newSchemeType);
        this.addSeparator();
        this.rename.addActionListener(this);
        this.add(this.rename);
        this.headingColour.addActionListener(this);
        this.add(this.headingColour);
        this.customHeadings.addActionListener(this);
        this.add(this.customHeadings);
        this.delete.addActionListener(this);
        this.add(this.delete);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String name;
        if (e.getSource().equals(this.newSchemeType)) {
            name = JOptionPane.showInputDialog(LegendaryCardMakerFrame.lcmf, "Enter the Scheme Type name", null);
            if (name == null) {
                return;
            }
            if (name != null && name.isEmpty()) {
                return;
            }
            JColorChooser chooser = new JColorChooser();
            Color bgColor = JColorChooser.showDialog(LegendaryCardMakerFrame.lcmf, "Select heading colour...", null);
            if (bgColor == null) {
                return;
            }
            boolean headings = false;
            int outcome = JOptionPane.showConfirmDialog(LegendaryCardMakerFrame.lcmf, "Custom Headings?", "Custom Headings?", 0, 3);
            headings = outcome == 0;
            SchemeCardType type = new SchemeCardType(bgColor, name.toUpperCase(), headings);
            SchemeCardType.values().add(type);
            this.getSchemeTypeListModel().addElement(type);
            SchemeCardType.saveSchemeTypeDefinitions();
        }
        if (e.getSource().equals(this.rename)) {
            if (this.getCurrentSchemeType() == null) {
                return;
            }
            name = JOptionPane.showInputDialog(this.lcmf, "Enter the Scheme Type name", this.getCurrentSchemeType().getEnumName());
            if (name == null) {
                return;
            }
            if (name != null && name.isEmpty()) {
                return;
            }
            this.getCurrentSchemeType().setDisplayString(name);
            SchemeCardType.saveSchemeTypeDefinitions();
        }
        if (e.getSource().equals(this.headingColour)) {
            if (this.getCurrentSchemeType() == null) {
                return;
            }
            JColorChooser chooser = new JColorChooser();
            Color outcome = JColorChooser.showDialog(this.lcmf, "Select heading colour...", this.getCurrentSchemeType().getBgColor());
            if (outcome != null) {
                this.getCurrentSchemeType().setBgColor(outcome);
            }
            SchemeCardType.saveSchemeTypeDefinitions();
        }
        if (e.getSource().equals(this.customHeadings)) {
            if (this.getCurrentSchemeType() == null) {
                return;
            }
            boolean headings = false;
            int outcome = JOptionPane.showConfirmDialog(this, "Custom Headings?", "Custom Headings?", 0, 3);
            headings = outcome == 0;
            this.getCurrentSchemeType().setAllowHeadings(headings);
            SchemeCardType.saveSchemeTypeDefinitions();
        }
        if (e.getSource().equals(this.delete)) {
            if (this.getCurrentSchemeType() == null) {
                return;
            }
            int outcome = JOptionPane.showOptionDialog(this.lcmf, "Delete Scheme Type?", "Delete Scheme Type?", 0, 3, null, null, null);
            if (outcome == 0) {
                SchemeCardType.values().remove(this.getCurrentSchemeType());
                this.getSchemeTypeListModel().removeElement(this.getCurrentSchemeType());
                SchemeCardType.saveSchemeTypeDefinitions();
            }
        }
    }

    public JList getSchemeTypeList() {
        return this.lcmf.schemeTypeList;
    }

    public DefaultListModel getSchemeTypeListModel() {
        return this.lcmf.schemeTypeListModel;
    }

    public SchemeCardType getCurrentSchemeType() {
        SchemeCardType i = null;
        if (this.lcmf.schemeTypeListModel.size() > 0 && this.lcmf.schemeTypeList.getSelectedIndex() >= 0) {
            i = (SchemeCardType)this.lcmf.schemeTypeListModel.get(this.lcmf.schemeTypeList.getSelectedIndex());
        }
        return i;
    }
}

